#ifndef __SDK_DEF_H__
#define __SDK_DEF_H__
#include "sdk_error.h"

#if defined(WIN32)
#if defined(SDKS_BUILD_DLL)
#define SDKS_API extern "C" __declspec(dllexport)
#elif defined(SDKS_USE_DLL)
#define SDKS_API extern "C"  __declspec(dllimport)
#else
#define SDKS_API
#endif
#else
#ifdef __cplusplus
#define SDKS_API extern "C"
#else
#define SDKS_API extern
#endif
#endif

typedef void(*SDK_NVR_SNAP_MSG_CB)(unsigned int handle, void* p_data, void* p_obj);
typedef void(*SDK_WIFI_CB)(unsigned int handle, char* p_data, void* p_obj);
typedef void(*SDK_ALARM_CB)(unsigned int handle, void** p_data, void* p_obj);
typedef void(*SDK_STREAM_CB)(unsigned int handle, int stream_id, void* p_data, void* p_obj);
typedef void(*SDK_STREAM_THERMAL_PIC_CB)(unsigned int handle, int stream_id, void** p_result, void* p_data, void* p_obj);
typedef void(*SDK_DISCONN_CB)(unsigned int handle, void* p_obj,int type);
typedef void(*SDK_CONNECT_CB)(unsigned int handle, void* p_obj);
typedef void(*SDK_PLAY_TIME_CB)(unsigned int handle, int stream_id, void* p_obj, const char* p_time);
typedef void(*SDK_STREAM_DATE_LEN)(unsigned long len);
typedef void(*SDK_DETECT_CB)(unsigned int handle, int stream_id, void** p_result, void* p_data, void* p_obj);
typedef void(*SDK_FACE_CB)(unsigned int handle, int pic_type,void* p_data, int *data_len, void** p_result, void* p_obj);//pic_type: 1׿⣬ 2ʵʱ
typedef void(*SDK_MUTI_OBJ_DOWNLOAD_CB)(unsigned int handle, void* p_pic1, int data_len1,char *key1 ,void* p_pic2, int data_len2, char *key2, void* p_obj);//pic_type: 1׿⣬ 2ʵʱ
typedef void(*SDK_NVR_COMPARE_CB)(unsigned int handle, void* p_pic1, int data_len1, void* p_pic2, int data_len2, void* p_result, void* p_obj);

typedef void(*SDK_MICROPHONE_CB)(unsigned int handle, void* p_data, int *data_len, void* p_obj);
typedef void(*SDK_INTERCOM_DB_CB)(unsigned int db, void*p_obj);
typedef void(*SDK_S3_PB_PLAY)(unsigned int handle, int stream_id, void* p_obj, void* p_data, unsigned int type);

#define MAX_DEV_NAME_LEN  128
#define MAX_IP_BUF_LEN  128
#define CONST_MAX_ALARM_IO_NUM  10					//IOָ֧
#define CONST_MAX_PERIOD_RECORD_TIME_NUM  16				//¼ʱθ
#define CONST_MAX_ALARM_OUT_NUM   16						//󱨾ͨ	
#define MAX_LENGTH_DEVICEID   32		//豸id
typedef enum  video_stream_type_e
{
	STREAM_TYPE_1 = 1,                     // HD
	STREAM_TYPE_2,                         // Smooth
	STREAM_TYPE_3
}video_stream_type_e;

enum Device_Type     //豸
{
	IPCAMERA = 1,	//豸
	DVR = 2,	//Ƶ¼豸
	DVS = 3,	//Ƶ豸
	IPDOME = 4,	//
	NVR = 5,	//NVR
	ONVIF_DEVICE = 6,	//Onvif 豸
	DECODER = 7,	//
	LPR = 8,	//ʶ
	FISHEYE = 9,    //豸͡
	NVR_2 = 10,   //ʾ4.0NVR
	IPP = 11,   //Ŀȫ
	THERMAL_DEVICE = 13,	//ȳ豸
	HUMAN_TEMPERATURE = 14,//
	FACE_DETECT = 15,//
	VEHICLE_DETECT = 16,//ڳ-о
	THERMAL_DOUBLE_SENSOR_DEVICE = 17,	//ȳ˫ͨ豸
	AIMULTI_OBJECT_DETECT = 18,//AI MULTI OBJECT DETECT
	THERMAL_DOUBLE_SENSOR_DOME_DEVICE = 19,	//ȳ˫ͨ豸(ɼӻо)
	DOMECORE_THERMAL_DEVICE = 20,			//а̨˫ippmd1030о
	FACE_DEVICE = 21,  //ܺ
	HK_DVR = 100,	//HK DVR
	RS_DVR = 101,	//DVR
	DH_DVR = 102,	//DVR
	VIRTUAL_NVR = 103,   //ڼNVRͻʹõıServer
	DOMECORE = 104	//о
};


typedef struct FRAME_INFO {
	long nWidth;	// λΪأƵΪ0
	long nHeight;	// ߣλΪأƵΪ0
	long nStamp;	// ʱϢλ
	long nType;		//ͣ±
	long nFrameRate;// ʱͼ֡
}FRAME_INFO;

typedef struct tagAVFrameData
{
	long					nStreamFormat;						//1ʾԭʼ2ʾTS3ʾԭʼ4ʾPS
	long					nESStreamType;						//ԭʼͣ1ʾƵ2ʾƵ
	long					nEncoderType;						//ʽ
	long					nCameraNo;							//ţʾԵڼ·
	unsigned long			nSequenceId;						//֡
	long					nFrameType;							//֡,1ʾI֡, 2ʾP֡, 0ʾδ֪
	long long				nAbsoluteTimeStamp;					//ݲɼʱλΪ΢
	long long				nRelativeTimeStamp;					//ݲɼʱλΪ΢
	char*					pszData;							//
	unsigned long			nDataLength;						//Ч
	long					nFrameRate;							//֡
	long					nBitRate;							//ǰʡ
	long					nImageFormatId;						//ǰʽ
	long					nImageWidth;						//Ƶ
	long					nImageHeight;						//Ƶ߶
	long					nVideoSystem;						//ǰƵʽ
	unsigned long			nFrameBufLen;						//ǰ峤

	long					nStreamId;							// ID
	long					nTimezone;							// ʱ
	long					nDaylightSavingTime;				//ʱ
}ST_AVFrameData;

typedef struct tagTargeHead
{
	int					targe_id;				//ĿId
	unsigned short		type;					//ͣ壬ƣ
	unsigned short		x;						//
	unsigned short		y;						//
	unsigned short		w;						//ο
	unsigned short		h;						//θ߶
	unsigned short		attr_data_len;			//ݳ

}tagTargeHead;

typedef struct tagPersonFace
{
	//tagTargeHead		headInfo;
	unsigned short		confidence;				//Ŷ
	unsigned short		yaw;					//
	unsigned short		tilt;					//б
	unsigned short		pitch;					//
	unsigned short		gender;					//Ա
	unsigned short		age;					//
	unsigned short		complexion;				//ɫ
	unsigned short		minority;				//
	float				temperature;			//¶
	unsigned short      temperature_unit;       //¶ȵλ
	char				reserve[30];			//Ԥֶ
	unsigned int		land_mark_size;			//
	//char*		        land_mark_data;			//
}tagPersonFace;

typedef struct _upbody_info_s
{
	//tagTargeHead		headInfo;
	unsigned short		confidence;
	unsigned short		gender;//sex ,[0-100],100--woman
	unsigned short		age;
	unsigned short		complexion;
	unsigned char		backpack;
	unsigned char		human_move;
	unsigned char		move_direction;
	unsigned char		ride_bike;
	unsigned char		ride_motorbike;
	unsigned char		human_face_visible;
	unsigned char		human_facing;
	unsigned char		human_facing_confidence;
}upbody_info_s;

typedef struct _plate_info_s
{
	//tagTargeHead		headInfo;
	unsigned short		have_plate;//Ƿг,0,1
	unsigned short		plate_angleH;//! Ƕ
	unsigned short		plate_angleV;//! Ƕ
	unsigned short		plate_color;	//! <ɫ
	unsigned short		plate_type;	//! <
	unsigned short		plate_confidence; //! <Ŷ
	unsigned short		plate_country;//! < Ĺ
	unsigned short		char_num;		//! <ַ
	char plate_num[32];		//! <ƺ
	char plate_char_confidence[32];//! <ƺÿַŶ
}plate_info_s;

typedef struct _vehicle_info_s
{
	//tagTargeHead		headInfo;
	unsigned short		have_plate;//Ƿг,0,1
	unsigned short		vehicle_plate_angleH;	//!<  ˮƽбǶ;
	unsigned short		vehicle_plate_angleV;	//!<  ƴֱбǶ;
	unsigned short		vehicle_color;	//!<  ɫ;
	unsigned short		vehicle_type; //!<  ͣǻ;
	unsigned short		confidence;
	unsigned short		vehicle_model; //!<  ͺţС
	unsigned short		vehicle_speed;	//!<  ʹٶ;
	unsigned short		Vehicle_moving;	//!< Ƿƶ
	unsigned short		char_num;		//! <ַ
	char				plate_num[32];		//! <ƺ
	char				plate_char_confidence[32];//! <ƺÿַŶ
	unsigned short		Move_direction;//!< ƶ
	unsigned short		Move_direction_confidence;//!< ƶŶ
	unsigned short		Vehicle_facing;//!< 
	unsigned short		Vehicle_facing_confidence;//!< Ŷ
	char				trademark_utf8[32];//!< Ʒ
	unsigned short		trademark_utf8_confidence;//!< ƷŶ
	unsigned short		Reserve;
}vehicle_info_s;

typedef struct tagDetectFaceData
{
	char				magic[4];				//ħţĬ0xffff ffff
	int					vesion;					//Э汾ţֽ
	unsigned int		total_len;				//ṹȣֽ
	unsigned int		picture_len;			//ͼƬݳȣֽ
	unsigned short		full_image_width;		//ͼĿFull_corp=0Чֽ
	unsigned short		full_image_hight;		//ͼĸߣFull_corp=0Чֽ												
	//long long			capture_time;           //Ŀʱ̵λ룬ֽ
	unsigned int capture_timeh;
	unsigned int capture_timel;
	unsigned int		sequence_id;			//ID,ֽ
	char				full_crop;				//ͼСͼ01С
	char				reserve[31];			//Ԥֶ
	unsigned int		target_size;			//Ŀֽ
}ST_DetectFaceData;
//ȳԭʼ
typedef struct tagThermalAVData
{
	char				magic[4];				//ħţĬ0xffff ffff
	unsigned int		vesion;					//Э汾ţֽ
	unsigned int		head_len;				//ͷݳȣֽ
	unsigned int		payload_len;			//ԭʼݳȣֽ
	unsigned int		image_width;			//rawͼĿֽ
	unsigned int		image_hight;			//rawͼĸߣֽ
	unsigned int		image_stride;			//rawͼȣֽΪλ, imageStride/imageWidth=ÿռֽĿǰrawͼǸ14bitЧֽ
	unsigned int		mirror_mode;			//rawͼģʽ: ˮƽֱˮƽֱ,ֽ
	unsigned int		capture_timeh;          //rawͼʱλֽ
	unsigned int		capture_timel;          //rawͼʱλֽ
	unsigned int		sequence_id;			//ID,ֽ
	char				reserve[64];			//Ԥֶ
}ST_ThermalAVData;


// Ӳ
typedef struct _dev_hw_cap_t_
{
	unsigned short				chn_num;	              //ͨ
	unsigned char				audio_in_num;	          //Ƶ
	unsigned char				sound_type;	              //Ƶͨ
	unsigned char				audio_out_num;	          //Ƶ
	unsigned char				alarm_in_num;	          //
	unsigned char				alarm_out_num;	          //
	unsigned char				rs485_num;	              //RS485ڸ
	unsigned char				rs232_Num;	              //RS232ڸ
	unsigned char				netcard_num;	          //
	unsigned char				usb_num;	              //USB
	unsigned char				sd_num;	                  //SDĸ
	unsigned char				hd_num;	                  //Ӳ̵ĸ
	unsigned char				is_wifi;	              //Ƿ֧wifi
	unsigned char				is_poe;	                  //Ƿ֧POE
	unsigned char				is_ir;	                  //Ƿֺ֧
	unsigned char				is_pir;	                  //Ƿ֧PIR
	unsigned char				is_bnc;	                  //Ƿ֧ģͨ
	unsigned char				is_ptz;	                  //Ƿ̨֧
	unsigned char				is_face;	                //Ƿ֧
	unsigned short              virtualPTZ_Type;            //PTZ
	unsigned short              aiDetec_Type;             //AI ץͣơΣʶ𣬸ͷḻ⣬hardware
	unsigned char				is_faceDetect;	           //Ƿ֧
	unsigned char               resv;                      // ֶ
}dev_hw_cap_t;

// 
typedef struct _dev_sw_cap_t_
{
	unsigned char				max_user_num;	    //¼û
	unsigned char				max_preview_num;	//ʵʱԤ·
	unsigned char				max_pb_num;	        //طź·
	unsigned char               resv;               //ֶ
}dev_sw_cap_t;

// Ƶ
typedef struct _dev_audio_cap_t_
{
	unsigned char               is_interphone;       //Խ
	unsigned char               is_audio_in;         //Ƶ
	unsigned char               is_audio_out;        //Ƶ
	unsigned char               resv;                //ֶ
}dev_audio_cap_t;

typedef struct _dev_sensor_check_t_
{
	int		channel_id;
	int		n_param;
}dev_sensor_check_t;

// 豸ҪϢ
typedef struct _dev_general_info_t_
{
	char	 dev_id[MAX_DEV_NAME_LEN];	                  //豸Id
	char	 dev_name[MAX_DEV_NAME_LEN];				  //豸
	char     dev_style[MAX_LENGTH_DEVICEID];			  //豸
	char	 dev_ip[MAX_IP_BUF_LEN];					  //豸IP
	char	 dev_mac[MAX_IP_BUF_LEN];					  //MACַ
	char	 dev_man_name[MAX_DEV_NAME_LEN];              //
	char	 dev_man_id[MAX_DEV_NAME_LEN];                //豸ͺ
	char	 prod_model[MAX_DEV_NAME_LEN];	              //Ʒģ
	char     dev_sn[MAX_DEV_NAME_LEN];	                  //SN
	char     sw_info[MAX_DEV_NAME_LEN];	                  //Ϣ
	char     hw_info[MAX_DEV_NAME_LEN];	                  //ӲϢ
	short    dev_type;                                   //豸
	unsigned short dev_port;                          //豸˿
}dev_general_info_t;

// 豸
typedef struct _dev_name_t_
{
	char dev_name[MAX_DEV_NAME_LEN];				  //豸
}dev_name_t;

// 豸ʱ
typedef struct _dev_time_t_
{
	unsigned short         year;                     //
	unsigned char          mon;                      //
	unsigned char          day;                      //
	unsigned char          hour;                     //ʱ
	unsigned char          min;                      //
	unsigned char          sec;                      //
	unsigned char          resv;                     //
}dev_time_t;

// ntp
typedef struct _ntp_param_t_
{
	char             serv_ip[MAX_IP_BUF_LEN];              //server ip
	unsigned short   serv_port;                            //server port
	unsigned char    is_enable;                            //Ƿntp
	unsigned char    ip_proto_ver;                         //ip Э汾
	unsigned int     ntp_time;                             //ntp time
}ntp_param_t;

typedef struct _dev_port_t_
{
	char                        dev_id[MAX_DEV_NAME_LEN];             //豸id
	unsigned short				ctrl_port;	                          //Ƶ豸豸ƶ˿
	unsigned short				av_port;	                          //Ƶ豸TCPƵ˿
	unsigned short				http_port;	                          //Ƶ豸豸HTTP˿
	unsigned short				https_port;	                          //Ƶ豸豸HTTPS˿
	unsigned short				rtsp_port;	                          //Ƶ豸豸RTSP˿
    unsigned short              ssl_port;
}dev_port_t;

// PTZ 
typedef enum ptz_operation_e
{
	PTZ_STOP = 0,  //ֹͣ	
	PTZ_UP = 1,        //
	PTZ_DOWN = 2,      //	
	PTZ_LEFT = 3,      //	
	PTZ_RIGHT = 4,     //		
	PTZ_LEFT_UP = 5,   //	
	PTZ_LEFT_DOWN = 6, //
	PTZ_RIGHT_UP = 7,  //
	PTZ_RIGHT_DOWN = 8, //
	PTZ_ZOOM_IN = 9,     //
	PTZ_ZOOM_OUT = 10,   //Զ	
	PTZ_FOCUS_FAR = 11,  //Զ
	PTZ_FOCUS_NEAR = 12,  //	
	PTZ_IRIS_INC = 13,   //Ȧ
	PTZ_IRIS_DEC = 14,   //ȦС
	PTZ_PRESET_SET = 15, //Ԥλ
	PTZ_PRESET_CALL = 16, //Ԥλ
	PTZ_PRESET_DEL = 17,  //Ԥλɾ
	//PTZ_TRACE_SET= 18,   //켣
	//PTZ_TRACE_CALL= 19,  //켣
	//PTZ_TRACE_DEL= 20,   //켣ɾ	
	PTZ_SCAN_CALL=21,    //ɨ
	PTZ_SCAN_SET_START = 22,  //ɨʼ
	PTZ_SCAN_SET_STOP = 23,  //ɨ
	PTZ_AUTO_FOCUS = 24,     //Զ۽	
	PTZ_AUTO_IRIS = 25,     //ԶȦ	
	PTZ_START_AUTO_STUDY = 26, //ʼѧϰ
	PTZ_END_AUTO_STUDY = 27,  //ѧϰ
	PTZ_RUN_AUTO_STUDY = 28,  //ѧϰ
	PTZ_RESET = 29,           //λ
	PTZ_3D_ORIENTATION = 30,  //άܶλ
	PTZ_TOUR_SET_START = 31,   //Ѳʼ
	PTZ_TOUR_ADD_PRESET = 32,  //ѲԤõ
	PTZ_TOUR_SET_END = 33,    //Ѳν
	PTZ_TOUR_RUN = 34,        //Ѳ
	PTZ_TOUR_PAUSE = 35,       //ͣѲ
	PTZ_TOUR_DEL = 36,        //ɾѲ
	PTZ_TOUR_CONTINUE = 200,   //ѲΣͣѲʹã
	PTZ_KEEPER_SET = 37,      //λ
	PTZ_KEEPER_RUN = 38,      //пλ
	PTZ_RUN_BRUSH = 39,      //ˢ
	PTZ_OPEN_LIGHT = 40,       //򿪵
	PTZ_CLOSE_LIGHT = 41,      //رյ
	PTZ_SCAN_REMOVE = 44,      //ɾɨ
	PTZ_REMOVE_AUTO_STUDY = 45,     //ɾѧϰ
	PTZ_INFRARED_CTRL = 46,        //ƿ
	PTZ_GET_PTZ_POSTION_REQ = 47,   //ȡPTZλ
	PTZ_GET_PTZ_POSTION_RESP = 48,   //PTZλӦ
	PTZ_SET_PTZ_POSTION = 49,        //PTZλ
	PTZ_SET_PTZ_NORTH_POSTION = 50,   //λ
	PTZ_GET_PRESET_REQ = 51,      //ȡԤλ
	PTZ_GET_PRESET_RESP = 52,     //ȡԤλӦ
	PTZ_GET_TOUR_REQ = 53,    //ȡѲ
	PTZ_GET_TOUR_RESP = 54,    //ȡѲӦ
	PTZ_GET_SCAN_REQ = 55,    //ȡɨ
	PTZ_GET_SCAN_RESP = 56,    //ȡɨӦ
	PTZ_GET_AUTO_STUDY_REQ = 57,    //ȡѧϰ
	PTZ_GET_AUTO_STUDY_RESP = 58,    //ȡѧϰӦ
	PTZ_GET_KEEPER_REQ = 59,     //ȡ
	PTZ_GET_KEEPER_RESP = 60,    //ȡӦ
	PTZ_INFRARED_STRL_V2 = 61,   //ƿչ
	PTZ_INFRARED_STRL_V2_REQ = 62,   //ƿƲ
	PTZ_STOP_BRUSH = 63,       //ˢֹͣ
	PTZ_360_ROTATE_SCAN = 64,  //360תɨ
	PTZ_PERPENDICVULAR_SCAN = 65,  //ֱɨ
	PTZ_HEART_BEAT = 66,       //
	PTZ_INFRARED_CTRL_V2_RESP = 67, //ƿƲӦ
	//PTZ_ZOOM_SPEED= 67,            //ͷԶٶֵãΪ뻪Ϊݣֵʱɳͻ
	PTZ_GET_ALARM_IO_START_REQ = 70,   //ȡIO״̬
	PTZ_GET_ALARM_IO_START_RESP = 71,  //IO״̬Ӧ
	PTZ_PT_STOP_STATUS_RESP = 72,     //PTֹͣ״̬ѯ
	PTZ_PT_POS_AUTO_RESP = 73,        //ԶϱPT
	PTA_ALARM_IO_STATUS_AUTO_RESP = 74,   //ԶϱIO״̬
	PTZ_GET_ZOOM_VALUE = 75,       //ͷ䱶ֵ
	PTZ_GET_PTZ_VERSION = 76,      //ȡPTZ汾
	PTZ_GET_MCU_TEMPERATURE = 77,   //ȡMCU¶
	PTZ_LOAD_DEFAULT = 78,          //в	
	PTZ_GET_PT_POSTION = 79,
	PTZ_SET_VERTICAL_MAX_POSTION = 80,
	PTZ_LENS_RESET = 81,	/*Զ۽ͷ(ABF)λ*//*BOOL*/
	PTZ_AUTO_TRACK = 82,
	PTZ_GET_PTZ_ACTION_STATUS_REQ = 83,	//ȡPTZ˶״̬
	PTZ_GET_PTZ_ACTION_STATUS_RESP = 84,	//PTZ˶״̬Ӧ
	PTZ_SET_WIPER_MODE = 85,	//ˢģʽ
	PTZ_GET_WIPER_MODE = 86,	//ȡˢģʽ
	PTZ_SET_PTZ_POWER_SAVE = 87,	//PTZʡ
	PTZ_GET_PTZ_POWER_SAVE = 88,	//ȡPTZʡ
	PTZ_SET_PT_LIMIT_POS = 89,	//PTλ
	PTZ_GET_PT_LIMIT_POS_REQ = 90,	//ȡPTλ
	PTZ_GET_PT_LIMIT_POS_RESP = 91,	//ȡPTλӦ
	PTZ_CLEAR_PT_LIMIT_POS = 92,	//PTλ
	PTZ_SET_PT_SELFCHECK = 93,	//PTԼ
	PTZ_GET_PT_SELFCHECK = 94,	//ȡPTԼ
	PTZ_SET_ORIENTATION = 95,	//ðװʽ
	PTZ_GET_ORIENTATION = 96,	//ȡװʽ
	PTZ_SET_SHORTCUT = 97,	//ÿݷʽ
	PTZ_GET_SHORTCUT = 98,	//ȡݷʽ
	PTZ_SET_DN_MODE = 99,	//ҹģʽ
	PTZ_SET_WHITE_LIGHT = 100,	//ð׹״̬
	PTZ_GET_WHITE_LIGHT = 101,	//ȡ׹״̬
	PTZ_GET_DN_MODE = 102,	//ȡҹģʽ
	PTZ_SET_ZOOM_VALUE = 103,	//ñ䱶ֵ
	PTZ_SET_FOCUS_VALUE = 104,	//þ۽ֵ
	PTZ_GET_FOCUS_VALUE = 105,	//ȡ۽ֵ
	PTZ_BOW_SCAN = 110,	//ɨ	
	PTZ_BOW_SCAN_SET_STARTPOINT = 111,	//ùɨʼ	
	PTZ_BOW_SCAN_SET_STOPPOINT = 112,	//ùɨ	
	PTZ_BOW_SCAN_REMOVE = 113,	//ɾɨ
	PTZ_BOW_SCAN_PAUSE = 114,	//ͣɨ
	PTZ_BOW_SCAN_CONTINUE = 115,	//ɨ
	PTZ_OPEN_DEFOG = 120,	//͸
	PTZ_CLOSE_DEFOG = 121,	//ر͸
	PTZ_HOME = 133	//صhomeλ
}ptz_operation_e;
enum SET_PTZ_POSION_TYPE
{
	POSTION_TYPE_PAN = 0x01, //ˮƽλ 
	POSTION_TYPE_TILE = 0x02, //ֱλ
	POSTION_TYPE_ZOOM = 0x04  //Ŵ
};
enum PTZ_DIRECTION
{
	EAST = 0x00,
	SOUTHEAST = 0x01,
	SOUTH = 0x02,
	SOUTHWEST = 0x03,
	WEST = 0x04,
	NORTHWEST = 0x05,
	NORTH = 0x06,
	NORTHEAST = 0x07
};
enum PTZ_RUN_KEEPER
{
	RUN_KEEPER_OFF = 0x00,	//رտλ
	RUN_KEEPER_ON = 0x02  //λ
};
enum PTZ_ZOOM
{
	ZOOM_SPEED_MIN = 0x00, //ͷԶٶֵСֵ
	ZOOM_SPEED_MAX = 0x3F  //ͷԶٶֵֵ
};
enum PTZ_ROTATE_TYPE
{
	ROTATE_TYPE_GEAR = 0x00,	//λ1-64
	ROTATE_TYPE_SPEED = 0x01,	//ٶ
	ROTATE_TYPE_DEGREE = 0x02	//
};
enum
{
	CONFIGURE_PRESET = 0,
	CONFIGURE_SCAN = 1,
	CONFIGURE_TRACK = 2,
	CONFIGURE_TOUR = 3,
	CONFIGURE_KEEPER = 4,
	CONFIGURE_GET_SPEED = 6,
};

//ʱ
typedef struct  _dev_time_zone_param_t_
{
	int				nTimeZone;												//ʱ

	unsigned char	bDSTOpenFlag;											//ʱ־

	int				nBeginMonth;											//ʱʼ·
	int				nBeginWeekly;											//ʱʼܣһеĵڼܣ
	int				nBeginWeekDays;											//ڼ
	unsigned int	nBeginTime;												//ʼʱ

	int				nEndMonth;												//ʱ·
	int				nEndWeekly;												//ʱܣһеĵڼܣ
	int				nEndWeekDays;											//ڼ
	unsigned int	nEndTime;												//ʱ

}dev_time_zone_param_t;

typedef struct _dev_modify_password_info_t_
{
	char dev_old_password[64];
	char dev_new_password[64];
}dev_modify_password_info_t;

typedef struct _dev_user_info_t_
{
	char dev_username[64];
	char dev_password[64];
}dev_user_info_t;




//ƻʱ
typedef struct _schedule_time_
{
	int week_day;
	unsigned long start_time;
	unsigned long end_time;
}schedule_time;

typedef struct _schedule_time_list_
{
	int					schedule_time_count;
	schedule_time	    time_list[CONST_MAX_PERIOD_RECORD_TIME_NUM];
}schedule_time_list;

typedef struct _detection_area_
{
	int width_num;
	int high_num;
	char data[512];
}detection_area;

typedef struct _time_struct_
{
	int				time_zone;				//ʱ
	unsigned short	day_light_saving_time;	//Ӫʱ
	unsigned short	year;					//
	unsigned short 	month;					//[1,12]
	unsigned short 	day;					//[1,31]
	unsigned short 	day_of_week;				//ڼ[0,6]
	unsigned short 	hour;					//ʱ[0,23]
	unsigned short 	minute;				//[0,59]
	unsigned short 	second;				//[0,59]
	int 			milli_seconds;			//΢[0,1000000]
}time_struct;

//////////////////motion detection///////////////////////////////
typedef struct _alarm_source_param_
{
	int					 enable;
	int					 alarm_interval;
	int				     check_block_num;
	int					 sensitivity;
	int                  time_list_size;
	int					 area_datalen;
	detection_area		 area;
	schedule_time		 time_list[200];
}alarm_source_param;

//
typedef struct _alarm_action_
{
	int action_type;	//Դ
	int action_id;		//ԴID
	char action_name[MAX_DEV_NAME_LEN];		//Դ
}alarm_action;

//PTZ
typedef struct _ptz_action_param_
{
	int ptz_action_type;	//ͣԤλ켣ȣ
	int ptz_action_id;		//IDû֮ǰõԤλID켣IDȣ
	int ptz_channel_id;		//PTZͨID
	alarm_action  alarm_act;
}ptz_action_param;

//
typedef struct _alarm_out_param_
{
	char dev_id[MAX_LENGTH_DEVICEID + 1];		//豸id
	int alarm_out_id;	//˿ڵID
	int alarm_out_flag;	//־
	int event_type_id;	//¼
	int alarm_time;		//ʱ
	alarm_action  alarm_act;
}alarm_out_param;

//¼
typedef struct _record_act_param_
{
	unsigned char pre_record_flag; //ǷԤ¼
	int			delay_record_time;	//¼ʱ
	alarm_action	alarm_act;
}record_act_param;


//
typedef struct _alarm_link_t_
{
	int			action_type;
	int			action_id;
}alarm_link;

typedef struct _mot_detect_param_
{
	alarm_source_param  objSourceParam;
	alarm_link          objLinkParamList[10];
	ptz_action_param    objPtzParamList[10];
	alarm_out_param		objAlarmOutList[10];
	record_act_param	objRecordActionList[10];
}mot_detect_param;

//IOͲ
typedef struct _io_alarm_insource_para_
{
	alarm_action		alarm_act;
	unsigned char		enable_flag;	//
	int					alarm_inval;	//
	int					valid_level;	//Чƽ
	schedule_time_list  schedule_para;
}io_alarm_insource_para;

typedef struct _io_alarm_event_para_
{
	io_alarm_insource_para   insource_para;
	int					linkage_param_count;
	alarm_link          link_param_list[CONST_MAX_ALARM_IO_NUM];
	int					ptz_action_action_param_list_count;
	ptz_action_param    ptz_param_list[CONST_MAX_ALARM_IO_NUM];
	int					alarm_out_count;
	alarm_out_param		alarm_out_list[CONST_MAX_ALARM_IO_NUM];
	int					record_action_param_list_count;
	record_act_param	record_action_list[CONST_MAX_ALARM_IO_NUM];
}io_alarm_event_para;

typedef struct _io_alarm_event_para_list_
{
	int		alarm_event_list_count;
	io_alarm_event_para alarm_event_list[CONST_MAX_ALARM_IO_NUM];
}io_alarm_event_para_list;

typedef struct _disk_alarm_source_para_
{
	alarm_action		alarm_act;
	unsigned short		enable_flag;	//Ƿ̱(false true)
	int		            alarm_inval;	//ϱλΪ룬СΪ10룬Ϊ86400(1)
	int					alarm_thresold;//ֵ, λΪٷֱ
	unsigned short		disk_full_enable_flag;
	unsigned short		disk_error_enable_flag;
	unsigned short		no_disk_enable_flag;
	schedule_time_list  schedule_para;
}disk_alarm_source_para;

//̱
typedef struct _disk_alarm_event_para_
{
	disk_alarm_source_para disk_alarm_source;
	int					linkage_param_count;
	alarm_link          link_param_list[CONST_MAX_ALARM_OUT_NUM];
	int					ptz_action_action_param_list_count;
	ptz_action_param    ptz_param_list[CONST_MAX_ALARM_OUT_NUM];
	int					alarm_out_count;
	alarm_out_param		alarm_out_list[CONST_MAX_ALARM_OUT_NUM];
	int					record_action_param_list_count;
	record_act_param	record_action_list[CONST_MAX_ALARM_OUT_NUM];
}disk_alarm_event_para;

typedef struct _disk_alarm_event_para_list_
{
	int					disk_alarm_event_count;
	disk_alarm_event_para disk_alarm_event_list[CONST_MAX_ALARM_OUT_NUM];
}disk_alarm_event_para_list;



//ѯϢ
typedef struct _qry_info_
{
	char				dev_id[MAX_LENGTH_DEVICEID + 1];		//豸ID
	long				channel_id;								//ͨ
	long				record_mode;							//ѯģʽ(¼ѯorղѯ)
	long				select_mode;							//ѯģʽ(0:У1Ͳѯ2ʱѯ)
	long				major_type;								//
	long				minor_type;								//
	long				precision;								//
	int					record_segment_interval;		////ѯʱ䳤ȣÿʱȣ
	time_struct			begin_time;						//ʼʱ
	time_struct			end_time;						//ʱ

}qry_info;


typedef struct _qry_info_list_
{
	int				qry_info_count;
	qry_info		qry_info_list[CONST_MAX_ALARM_OUT_NUM];
}qry_info_para_list;

typedef struct  _alarm_info_qry_
{
	char			dev_ip[MAX_IP_BUF_LEN];					//豸IP
	char			dev_id[MAX_LENGTH_DEVICEID + 1];
	int				source_id;	//ԴId
	int				select_mode;	//ѯģʽ :SELECT_MODE_ALL
	char			source_name[MAX_DEV_NAME_LEN];	//Դ
	int				major_type;	//
	int				minor_type;	//
	unsigned long				alarm_begin_time;	//ѯʼʱ
	time_struct				alarm_begin_time_struct;	//
	unsigned long				alarm_end_time;	//ѯʱ
	time_struct				alarm_end_time_struct;	//
}alarm_info_qry;

//ȳݺͼƬ
typedef struct tagThermalAVDataPic
{
	char				magic[4];				//ħţĬ0xffff ffff
	unsigned int		vesion;					//Э汾ţֽ
	unsigned int		head_len;				//ͷݳȣֽ
	unsigned int		temper_payload_len;			//ʾܴСֽ
	unsigned int		image_payload_len;		//ʾͼܴСֽ
	unsigned int		width;					//¾ֽ򣨾ͷݿʼ
	unsigned int		hight;					//¾ߣֽ
	unsigned int		image_stride;			//rawͼȣֽΪλ, imageStride/imageWidth=ÿռֽĿǰrawͼǸ14bitЧֽ
	unsigned int		temper_data_zoom_in;	//ݷŴı,¶ȳԸֵõʵ¶ȣ12345/100=123.45
	unsigned int		mirror_mode;			//rawͼģʽ: ˮƽֱˮƽֱ,ֽ
	unsigned int		capture_timeh;          //rawͼʱλֽ
	unsigned int		capture_timel;          //rawͼʱλֽ
	unsigned int		sequence_id;			//rawͼк,ÿμӣֽ
	unsigned int		image_type;				//0:JPGֽ
	unsigned int		image_width;			//ͼֽ
	unsigned int		image_height;			//ͼֽ
	char				reserve[64];			//Ԥֶ
}ST_ThermalAVDataPic;


#ifdef WIN32
typedef enum sdks_zoomin_graduate_e
{
	SDKS_ZOOMIN_GRADUATE_MIN = 0, ///<Ŵ
	SDKS_ZOOMIN_GRADUATE_1,       ///<Ŵʼ0.25 
	SDKS_ZOOMIN_GRADUATE_2,       ///<Ŵʼ0.5 
	SDKS_ZOOMIN_GRADUATE_3,       ///<Ŵʼ0.75 
	SDKS_ZOOMIN_GRADUATE_4,       ///<Ŵʼ1.0 
	SDKS_ZOOMIN_GRADUATE_5,       ///<Ŵʼ1.25 
	SDKS_ZOOMIN_GRADUATE_6,       ///<Ŵʼ1.5 
	SDKS_ZOOMIN_GRADUATE_7,       ///<Ŵʼ1.75 
	SDKS_ZOOMIN_GRADUATE_8,       ///<Ŵʼ2.0 
	SDKS_ZOOMIN_GRADUATE_9,       ///<Ŵʼ2.25 
	SDKS_ZOOMIN_GRADUATE_10,      ///<Ŵʼ2.5 
	SDKS_ZOOMIN_GRADUATE_11,      ///<Ŵʼ2.75 
	SDKS_ZOOMIN_GRADUATE_12,      ///<Ŵʼ3.0
	SDKS_ZOOMIN_GRADUATE_13,      ///<Ŵʼ3.25 
	SDKS_ZOOMIN_GRADUATE_14,      ///<Ŵʼ3.5 
	SDKS_ZOOMIN_GRADUATE_15,      ///<Ŵʼ3.75 
	SDKS_ZOOMIN_GRADUATE_16,      ///<Ŵʼ4.0 
	SDKS_ZOOMIN_GRADUATE_17,      ///<Ŵʼ4.25 
	SDKS_ZOOMIN_GRADUATE_18,      ///<Ŵʼ4.5 
	SDKS_ZOOMIN_GRADUATE_19,      ///<Ŵʼ4.75
	SDKS_ZOOMIN_GRADUATE_20,	  ///<Ŵʼ5.0 
	SDKS_ZOOMIN_GRADUATE_21,	  ///<Ŵʼ5.25
	SDKS_ZOOMIN_GRADUATE_22,	  ///<Ŵʼ5.5 
	SDKS_ZOOMIN_GRADUATE_23,	  ///<Ŵʼ5.75
	SDKS_ZOOMIN_GRADUATE_24,	  ///<Ŵʼ6.0 
	SDKS_ZOOMIN_GRADUATE_25,	  ///<Ŵʼ6.25
	SDKS_ZOOMIN_GRADUATE_26,	  ///<Ŵʼ6.5 
	SDKS_ZOOMIN_GRADUATE_27,	  ///<Ŵʼ6.75
	SDKS_ZOOMIN_GRADUATE_28,	  ///<Ŵʼ7.0 
	SDKS_ZOOMIN_GRADUATE_29,	  ///<Ŵʼ7.25
	SDKS_ZOOMIN_GRADUATE_30,	  ///<Ŵʼ7.5 
	SDKS_ZOOMIN_GRADUATE_31,	  ///<Ŵʼ7.75
	SDKS_ZOOMIN_GRADUATE_32,	  ///<Ŵʼ8.0 
	SDKS_ZOOMIN_GRADUATE_33,	  ///<Ŵʼ8.25
	SDKS_ZOOMIN_GRADUATE_34,	  ///<Ŵʼ8.5 
	SDKS_ZOOMIN_GRADUATE_35,	  ///<Ŵʼ8.75
	SDKS_ZOOMIN_GRADUATE_36,	  ///<Ŵʼ9.0 
	SDKS_ZOOMIN_GRADUATE_37,	  ///<Ŵʼ9.25
	SDKS_ZOOMIN_GRADUATE_38,	  ///<Ŵʼ9.5 
	SDKS_ZOOMIN_GRADUATE_39,	  ///<Ŵʼ9.75
	SDKS_ZOOMIN_GRADUATE_40,	  ///<Ŵʼ10.0 
	SDKS_ZOOMIN_GRADUATE_41,	  ///<Ŵʼ10.25
	SDKS_ZOOMIN_GRADUATE_42,	  ///<Ŵʼ10.5 
	SDKS_ZOOMIN_GRADUATE_43,	  ///<Ŵʼ10.75
	SDKS_ZOOMIN_GRADUATE_44,	  ///<Ŵʼ11.0 
	SDKS_ZOOMIN_GRADUATE_45,	  ///<Ŵʼ11.25
	SDKS_ZOOMIN_GRADUATE_46,	  ///<Ŵʼ11.5 
	SDKS_ZOOMIN_GRADUATE_47,	  ///<Ŵʼ11.75
	SDKS_ZOOMIN_GRADUATE_48,	  ///<Ŵʼ12.0 
	SDKS_ZOOMIN_GRADUATE_49,	  ///<Ŵʼ12.25
	SDKS_ZOOMIN_GRADUATE_50,	  ///<Ŵʼ12.5 
	SDKS_ZOOMIN_GRADUATE_51,	  ///<Ŵʼ12.75
	SDKS_ZOOMIN_GRADUATE_52,	  ///<Ŵʼ13.0 
	SDKS_ZOOMIN_GRADUATE_53,	  ///<Ŵʼ13.25
	SDKS_ZOOMIN_GRADUATE_54,	  ///<Ŵʼ13.5 
	SDKS_ZOOMIN_GRADUATE_55,	  ///<Ŵʼ13.75
	SDKS_ZOOMIN_GRADUATE_56,	  ///<Ŵʼ14.0 
	SDKS_ZOOMIN_GRADUATE_57,	  ///<Ŵʼ14.25
	SDKS_ZOOMIN_GRADUATE_58,	  ///<Ŵʼ14.5 
	SDKS_ZOOMIN_GRADUATE_59,	  ///<Ŵʼ14.75
	SDKS_ZOOMIN_GRADUATE_60,	  ///<Ŵʼ15.0 
	SDKS_ZOOMIN_GRADUATE_MAX
}sdks_zoomin_graduate_e;

#endif

#endif
